<?php

    include '../lib/locale/en_EN/messages.php';


//vars
if(isset($_SERVER['HTTP_HOST'])){
    $protocol = ( (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') || $_SERVER['SERVER_PORT'] == 443) ? 'https://' : 'http://' ;
    $site_url_full =  $protocol.$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
    $uri_parts = explode('?',$site_url_full);
    $site_url = (isset($uri_parts[0])) ? $uri_parts[0] : $site_url_full;
} else {
    $site_url = 'http://localhost';
}
$lang_doc = (!empty($lang)) ? str_replace('_','-',$lang) : 'en-EN';
?>

<!DOCTYPE html>
<html lang="<?php echo $lang; ?>">
<head>
    <meta charset="UTF-8">
    <title>Lyra PG</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/css/bootstrap.min.css" />
    <script   src="https://code.jquery.com/jquery-2.2.4.min.js"   integrity="sha256-BbhdlvQf/xTY9gja0Dq3HiwQF8LaCRTXxZKRutelT44="   crossorigin="anonymous"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/js/bootstrap.min.js"></script>
    <!-- Custom CSS -->
    <style>
        body {
            padding-top: 70px;
            /* Required padding for .navbar-fixed-top. Remove if using .navbar-static-top. Change if height of navigation changes. */
            padding-bottom: 8em;
        }
        .form-control{min-width: 220px;}
    </style>
</head>
<body>

<!-- Navigation -->


<!-- Page Content -->
<div class="container">
    <div class="row">
        <div class="col-lg-12" style="max-width: 92%;">
            <br><br>
            <div class="bg-info">
                <div style="padding: 2em;">
                <h2><?php echo $i18n['lpg']; ?> </h2>
                <div id="Info">
                    <p><b><?php echo $i18n['info']; ?></b></p>
                    <p><?php echo $i18n['usesform']; ?></p>
                    <p><strong><?php echo $i18n['file']; ?> config.php</strong></p>
                    <p><?php echo $i18n['beforefirstuse']; ?></p>

                    <p><strong><u><?php echo $i18n['file']; ?> html-form.php</u></strong></p>
                    <p><?php echo $i18n['htmlformuse']; ?></p>

                </div>
                </div>
            </div>

<form style="margin-top:10px;" method="POST" action="form-tunnel.php">
    <table class="table table-bordered">
        <tbody>
        <tr>
            <td colspan="3" class="title_array"><h2><?php echo $i18n['transsettings']; ?></h2></td>
        </tr>
        <tr>
            <td class="field_mandatory">vads_amount</a></td>
            <td><input type="text" class="form-control" name="vads_amount" value="1000" size="20"></td>
            <td  class="text-right text-danger">
                <?php echo $i18n['amountdesc']; ?></td>
        </tr>

        <tr>
            <td colspan="3"><h3><?php echo $i18n['clientssettings']; ?></h3></td>
        </tr>

        <tr>
            <td>vads_order_id</a></td>
            <td><input type="text" class="form-control" name="vads_order_id" value="123456" size="20"></td>
            <td><?php echo $i18n['orderdesc']; ?></td>
        </tr>

        <tr>
            <td>vads_cust_id</a></td>
            <td><input type="text" class="form-control" name="vads_cust_id" value="2380" size="20"></td>
            <td class="text-right"><?php echo $i18n['custid']; ?></td>
        </tr>
        <tr>
            <td>vads_cust_name</a></td>
            <td><input type="text" class="form-control" name="vads_cust_name" value="Akash Tiwari" size="20"></td>
            <td class="text-right"><?php echo $i18n['custname']; ?></td>
        </tr>
        <tr>
            <td>vads_cust_address</a></td>
            <td><input type="text" class="form-control" name="vads_cust_address" value="Techniplex 1, Techniplex Complex, Goregoan West" size="20"></td>
            <td class="text-right"><?php echo $i18n['custaddress']; ?></td>
        </tr>
        <tr>
            <td>vads_cust_zip</a></td>
            <td><input type="text" class="form-control" name="vads_cust_zip" value="400064" size="20"></td>
            <td class="text-right"><?php echo $i18n['custzip']; ?></td>
        </tr>
        <tr>
            <td>vads_cust_city</a></td>
            <td><input type="text" class="form-control" name="vads_cust_city" value="MUMBAI" size="20"></td>
            <td class="text-right"><?php echo $i18n['custcity']; ?></td>
        </tr>
        <tr>
            <td>vads_cust_country</a></td>
            <td><input type="text" class="form-control" name="vads_cust_country" value="IN" size="20"></td>
            <td class="text-right"><?php echo $i18n['custcountry']; ?></td>
        </tr>
        <tr>
            <td>vads_cust_phone</a></td>
            <td><input type="text" class="form-control" name="vads_cust_phone" value="9876543211" size="20"></td>
            <td class="text-right"><?php echo $i18n['custphone']; ?></td>
        </tr>
        <tr>
            <td>vads_cust_email</a></td>
            <td><input type="text" class="form-control" name="vads_cust_email" size="20" value="akash.tiwari@lyra-network.co.in" placeholder="akash.tiwari@lyra-network.co.in"></td>
            <td class="text-right"><?php echo $i18n['custemail']; ?></td>
        </tr>

        <tr>
            <td colspan="3"><h3><?php echo $i18n['returnurl']; ?></h3></td>
        </tr>

        <tr>
            <td>vads_url_return</a></td>
            <td><input type="text" class="form-control" name="vads_url_return" value="http://localhost/lyraPG/return/form-return.php" placeholder="http://localhost/return/form-return.php" size="20"></td>
            <td><?php echo $i18n['urlreturndesc']; ?></td>
        </tr>
        <tr>
            <td>vads_redirect_success_timeout</a></td>
            <td><input type="text" class="form-control" name="vads_redirect_success_timeout" value="10" placeholder="10" size="20"></td>
            <td><?php echo $i18n['redirect']; ?></td>
        </tr>

        </tbody></table>
    <br><br>

    <button type="submit" class="btn btn-primary btn-lg btn-block">
        Submit
    </button>
</form>
</div>
        </div>
    </div>

<br><br>
<hr>
<br>
</body>
</html>